<?php header("Content-Type:text/html;charset=utf-8"); ?>
<?php //error_reporting(E_ALL | E_STRICT);
##-----------------------------------------------------------------------------------------------------------------##
#
#  PHPメールプログラム　フリー版 ver2.0.3 最終更新日2022/02/01
#　改造や改変は自己責任で行ってください。
#	
#  HP: http://www.php-factory.net/
#
#  重要！！サイトでチェックボックスを使用する場合のみですが。。。
#  チェックボックスを使用する場合はinputタグに記述するname属性の値を必ず配列の形にしてください。
#  例　name="当サイトをしったきっかけ[]"  として下さい。
#  nameの値の最後に[と]を付ける。じゃないと複数の値を取得できません！
#
##-----------------------------------------------------------------------------------------------------------------##
if (version_compare(PHP_VERSION, '5.1.0', '>=')) {//PHP5.1.0以上の場合のみタイムゾーンを定義
	date_default_timezone_set('Asia/Tokyo');//タイムゾーンの設定（日本以外の場合には適宜設定ください）
}
/*-------------------------------------------------------------------------------------------------------------------
* ★以下設定時の注意点　
* ・値（=の後）は数字以外の文字列（一部を除く）はダブルクオーテーション「"」、または「'」で囲んでいます。
* ・これをを外したり削除したりしないでください。後ろのセミコロン「;」も削除しないください。
* ・また先頭に「$」が付いた文字列は変更しないでください。数字の1または0で設定しているものは必ず半角数字で設定下さい。
* ・メールアドレスのname属性の値が「Email」ではない場合、以下必須設定箇所の「$Email」の値も変更下さい。
* ・name属性の値に半角スペースは使用できません。
*以上のことを間違えてしまうとプログラムが動作しなくなりますので注意下さい。
-------------------------------------------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------------------------
【スパム対策用コード】(START)
※指定のキーワードが含まれていたら強制終了する処理(送信させない)
------------------------------------------------------------------------------------------------*/

//禁止するキーワードを設定下さい（値は'で囲み、カンマで区切って下さい）
//無効化する場合には $ngwordArr = array();　として下さい。
$ngwordArr = array('禁止ワード','NGワード');

//文字コードの指定（フォームの文字コードに合わせて下さい）
$targetEncode = 'utf-8';

//キーワードマッチング処理（基本的に変更禁止）
if(!empty($ngwordArr)){
foreach($_POST as $key => $val){
	foreach($ngwordArr as $vv){
		if($key != 'httpReferer' && !is_array($val) && mb_strpos($val,$vv,0,$targetEncode) !== false) exit('Error');
	}
}
}
/*------------------------------------------------------------------------------------------------
【スパム対策用コード】(END)
------------------------------------------------------------------------------------------------*/

//ユーザーの言語設定に「zh」（中国語簡体、中国語繁体）が含まれる場合に強制終了する
//ただし、中国語での問い合わせも受付けている場合は当然使用不可です。
if(strpos(substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2),'zh') !== false){
	exit();
}

//---------------------------　必須設定　必ず設定してください　-----------------------

//サイトのトップページのURL　※デフォルトでは送信完了後に「トップページへ戻る」ボタンが表示されますので
$site_top = "https://daiichi-kankoubus.com";

//管理者のメールアドレス ※メールを受け取るメールアドレス(複数指定する場合は「,」で区切ってください 例 $to = "aa@aa.aa,bb@bb.bb";)
$to = "info@daiichi-kankoubus.com";

//送信元メールアドレス（管理者宛て、及びユーザー宛メールの送信元メールアドレスです）
//必ず実在するメールアドレスでかつ出来る限り設置先サイトのドメインと同じドメインのメールアドレスとすることを強く推奨します
//管理者宛てメールの返信先（reply）はユーザーのメールアドレスになります。
$from = "info@daiichi-kankoubus.com";

//フォームのメールアドレス入力箇所のname属性の値（name="○○"　の○○部分）
$Email = "返信用Eメールアドレス";
//---------------------------　必須設定　ここまで　------------------------------------


//---------------------------　セキュリティ、スパム防止のための設定　------------------------------------

//スパム防止のためのリファラチェック（フォーム側とこのファイルが同一ドメインであるかどうかのチェック）(する=1, しない=0)
//※有効にするにはこのファイルとフォームのページが同一ドメイン内にある必要があります
$Referer_check = 1;

//リファラチェックを「する」場合のドメイン ※設置するサイトのドメインを指定して下さい。
//もしこの設定が間違っている場合は送信テストですぐに気付けます。
$Referer_check_domain = "daiichi-kankoubus.com";

/*セッションによるワンタイムトークン（CSRF対策、及びスパム防止）(する=1, しない=0)
※ただし、この機能を使う場合は↓の送信確認画面の表示が必須です。（デフォルトではON（1）になっています）
※【重要】ガラケーは機種によってはクッキーが使えないためガラケーの利用も想定してる場合は「0」（OFF）にして下さい（PC、スマホは問題ないです）*/
$useToken = 1;
//---------------------------　セキュリティ、スパム防止のための設定　ここまで　------------------------------------


//---------------------- 任意設定　以下は必要に応じて設定してください ------------------------

// Bccで送るメールアドレス(複数指定する場合は「,」で区切ってください 例 $BccMail = "aa@aa.aa,bb@bb.bb";)
$BccMail = "";

// 管理者宛に送信されるメールのタイトル（件名）
$subject = "ホームページのお問い合わせ";

// 送信確認画面の表示(する=1, しない=0)
$confirmDsp = 1;

// 送信完了後に自動的に指定のページ(サンクスページなど)に移動する(する=1, しない=0)
// CV率を解析したい場合などはサンクスページを別途用意し、URLをこの下の項目で指定してください。
// 0にすると、デフォルトの送信完了画面が表示されます。
$jumpPage = 1;

// 送信完了後に表示するページURL（上記で1を設定した場合のみ）※httpから始まるURLで指定ください。（相対パスでも基本的には問題ないです）
$thanksPage = "thanks.html";

// 必須入力項目を設定する(する=1, しない=0)
$requireCheck = 1;

/* 必須入力項目(入力フォームで指定したname属性の値を指定してください。（上記で1を設定した場合のみ）
値はシングルクォーテーションで囲み、複数の場合はカンマで区切ってください。フォーム側と順番を合わせると良いです。 
配列の形「name="○○[]"」の場合には必ず後ろの[]を取ったものを指定して下さい。*/
$require = array('お問い合わせ内容','希望の返信方法','団体名／会社名','お名前','お名前（ふりがな）','返信用Eメールアドレス','確認用Eメールアドレス','返信用電話番号','プライバシーポリシーへの同意');


//----------------------------------------------------------------------
//  自動返信メール設定(START)
//----------------------------------------------------------------------

// 差出人に送信内容確認メール（自動返信メール）を送る(送る=1, 送らない=0)
// 送る場合は、フォーム側のメール入力欄のname属性の値が上記「$Email」で指定した値と同じである必要があります
$remail = 1;

//自動返信メールの送信者欄に表示される名前　※あなたの名前や会社名など（もし自動返信メールの送信者名が文字化けする場合ここは空にしてください）
$refrom_name = "";

// 差出人に送信確認メールを送る場合のメールのタイトル（上記で1を設定した場合のみ）
$re_subject = "送信ありがとうございました";

//フォーム側の「名前」箇所のname属性の値　※自動返信メールの「○○様」の表示で使用します。
//指定しない、または存在しない場合は、○○様と表示されないだけです。あえて無効にしてもOK
$dsp_name = 'お名前';

//自動返信メールの冒頭の文言 ※日本語部分のみ変更可
$remail_text = <<< TEXT

お問い合わせありがとうございました。
早急にご返信致しますので今しばらくお待ちください。

送信内容は以下になります。

TEXT;


//自動返信メールに署名（フッター）を表示(する=1, しない=0)※管理者宛にも表示されます。
$mailFooterDsp = 0;

//上記で「1」を選択時に表示する署名（フッター）（FOOTER～FOOTER;の間に記述してください）
$mailSignature = <<< FOOTER

＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝

　第一観光産業株式会社

　〒989-6235 宮城県大崎市古川宮沢字舘ノ内94番地
　TEL：0229-28-1636 FAX：0229-28-1648
　Email: daiichi-kankoubus.com
　URL: https://daiichi-kankoubus.com

＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝

FOOTER;


//----------------------------------------------------------------------
//  自動返信メール設定(END)
//----------------------------------------------------------------------

//メールアドレスの形式チェックを行うかどうか。(する=1, しない=0)
//※デフォルトは「する」。特に理由がなければ変更しないで下さい。メール入力欄のname属性の値が上記「$Email」で指定した値である必要があります。
$mail_check = 1;

//全角英数字→半角変換を行うかどうか。(する=1, しない=0)
$hankaku = 0;

//全角英数字→半角変換を行う項目のname属性の値（name="○○"の「○○」部分）
//※複数の場合にはカンマで区切って下さい。（上記で「1」を指定した場合のみ有効）
//配列の形「name="○○[]"」の場合には必ず後ろの[]を取ったものを指定して下さい。
$hankaku_array = array('返信用電話番号','FAX番号');

//-fオプションによるエンベロープFrom（Return-Path）の設定(する=1, しない=0)　
//※宛先不明（間違いなどで存在しないアドレス）の場合に 管理者宛に「Mail Delivery System」から「Undelivered Mail Returned to Sender」というメールが届きます。
//サーバーによっては稀にこの設定が必須の場合もあります。
//設置サーバーでPHPがセーフモードで動作している場合は使用できませんので送信時にエラーが出たりメールが届かない場合は「0」（OFF）として下さい。
$use_envelope = 0;

//機種依存文字の変換
/*たとえば㈱（かっこ株）や①（丸1）、その他特殊な記号や特殊な漢字などは変換できずに「？」と表示されます。それを回避するための機能です。
確認画面表示時に置換処理されます。「変換前の文字」が「変換後の文字」に変換され、送信メール内でも変換された状態で送信されます。（たとえば「㈱」の場合、「（株）」に変換されます） 
必要に応じて自由に追加して下さい。ただし、変換前の文字と変換後の文字の順番と数は必ず合わせる必要がありますのでご注意下さい。*/

//変換前の文字
$replaceStr['before'] = array('①','②','③','④','⑤','⑥','⑦','⑧','⑨','⑩','№','㈲','㈱','髙');
//変換後の文字
$replaceStr['after'] = array('(1)','(2)','(3)','(4)','(5)','(6)','(7)','(8)','(9)','(10)','No.','（有）','（株）','高');

//------------------------------- 任意設定ここまで ---------------------------------------------


// 以下の変更は知識のある方のみ自己責任でお願いします。

//----------------------------------------------------------------------
//  関数実行、変数初期化
//----------------------------------------------------------------------
//トークンチェック用のセッションスタート
if($useToken == 1 && $confirmDsp == 1){
	session_name('PHPMAILFORMSYSTEM');
	session_start();
}
$encode = "UTF-8";//このファイルの文字コード定義（変更不可）
if(isset($_GET)) $_GET = sanitize($_GET);//NULLバイト除去//
if(isset($_POST)) $_POST = sanitize($_POST);//NULLバイト除去//
if(isset($_COOKIE)) $_COOKIE = sanitize($_COOKIE);//NULLバイト除去//
if($encode == 'SJIS') $_POST = sjisReplace($_POST,$encode);//Shift-JISの場合に誤変換文字の置換実行
$funcRefererCheck = refererCheck($Referer_check,$Referer_check_domain);//リファラチェック実行

//変数初期化
$sendmail = 0;
$empty_flag = 0;
$post_mail = '';
$errm ='';
$header ='';

if($requireCheck == 1) {
	$requireResArray = requireCheck($require);//必須チェック実行し返り値を受け取る
	$errm = $requireResArray['errm'];
	$empty_flag = $requireResArray['empty_flag'];
}
//メールアドレスチェック
if(empty($errm)){
	foreach($_POST as $key=>$val) {
		if($val == "confirm_submit") $sendmail = 1;
		if($key == $Email) $post_mail = h($val);
		if($key == $Email && $mail_check == 1 && !empty($val)){
			if(!checkMail($val)){
				$errm .= "<p class=\"error_messe\">【".$key."】はメールアドレスの形式が正しくありません。</p>\n";
				$empty_flag = 1;
			}
		}
	}
}
  
if(($confirmDsp == 0 || $sendmail == 1) && $empty_flag != 1){
	
	//トークンチェック（CSRF対策）※確認画面がONの場合のみ実施
	if($useToken == 1 && $confirmDsp == 1){
		if(empty($_SESSION['mailform_token']) || ($_SESSION['mailform_token'] !== $_POST['mailform_token'])){
			exit('ページ遷移が不正です');
		}
		if(isset($_SESSION['mailform_token'])) unset($_SESSION['mailform_token']);//トークン破棄
		if(isset($_POST['mailform_token'])) unset($_POST['mailform_token']);//トークン破棄
	}
	
	//差出人に届くメールをセット
	if($remail == 1) {
		$userBody = mailToUser($_POST,$dsp_name,$remail_text,$mailFooterDsp,$mailSignature,$encode);
		$reheader = userHeader($refrom_name,$from,$encode);
		$re_subject = "=?iso-2022-jp?B?".base64_encode(mb_convert_encoding($re_subject,"JIS",$encode))."?=";
	}
	//管理者宛に届くメールをセット
	$adminBody = mailToAdmin($_POST,$subject,$mailFooterDsp,$mailSignature,$encode,$confirmDsp);
	$header = adminHeader($post_mail,$BccMail);
	$subject = "=?iso-2022-jp?B?".base64_encode(mb_convert_encoding($subject,"JIS",$encode))."?=";
	
	//-fオプションによるエンベロープFrom（Return-Path）の設定(safe_modeがOFFの場合かつ上記設定がONの場合のみ実施)
	if($use_envelope == 0){
		mail($to,$subject,$adminBody,$header,'-f'. $to);
		if($remail == 1 && !empty($post_mail)) mail($post_mail,$re_subject,$userBody,$reheader);
	}else{
		mail($to,$subject,$adminBody,$header,'-f'.$from);
		if($remail == 1 && !empty($post_mail)) mail($post_mail,$re_subject,$userBody,$reheader,'-f'.$from);
	}
}
else if($confirmDsp == 1){ 

/*　▼▼▼送信確認画面のレイアウト※編集可　オリジナルのデザインも適用可能▼▼▼　*/
?>
<!doctype html>
<html><!-- InstanceBegin template="/Templates/Template.dwt" codeOutsideHTMLIsLocked="false" -->
<head>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-ZXLWNYYFFC"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-ZXLWNYYFFC');
</script>

<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
<link rel="manifest" href="favicon/site.webmanifest">
<link rel="mask-icon" href="favicon/safari-pinned-tab.svg" color="#5bbad5">
<meta name="msapplication-TileColor" content="#ffffff">
<meta name="theme-color" content="#ffffff">

<meta charset="utf-8">
<!-- InstanceBeginEditable name="doctitle" -->
<title>第一観光バス｜宮城県大崎市｜一般貸旅客自動車運送事業・貸切観光バス</title>
<!-- InstanceEndEditable -->
<meta name="description" content="宮城県大崎市で少人数からのマイクロバスから大型観光バスまで、幅広く貸し切りバスをご提供しています。宮城県バス協会所属">
<meta name="keywords" content="宮城県,大崎市,古川,マイクロバス,バス,大型観光バス,大型バス,貸し切りバス">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta name="viewport" content="width=device-width">
<link href="css/style.css" rel="stylesheet" type="text/css" media="only screen and (min-width:751px)">
<link href="css/style_s.css" rel="stylesheet" type="text/css" media="only screen and (min-width:320px) and (max-width:750px)">
<!-- InstanceBeginEditable name="css" -->
<link href="css/contact.css" rel="stylesheet" type="text/css" media="only screen and (min-width:751px)">
<link href="css/contact_s.css" rel="stylesheet" type="text/css" media="only screen and (min-width:320px) and (max-width:750px)">
<link rel="stylesheet" type="text/css" href="css/slick.css" media="screen" />
<!-- InstanceEndEditable -->
<link href="css/slick-theme.css" rel="stylesheet" type="text/css" media="only screen and (min-width:751px)">
<link href="css/slick-theme_s.css" rel="stylesheet" type="text/css" media="only screen and (min-width:320px) and (max-width:750px)">
<script type="text/javascript" src="js/jquery-1.8.3.min.js"></script>
<!-- InstanceBeginEditable name="js" -->
<!-- InstanceEndEditable -->
</head>

<body>

<header>
<h1>
<a href="index.html">
第一観光バス
</a>
</h1>
<p>
一般貸切旅客自動車運送事業・貸切観光バス
</p>
<div class="clear">
</div>
<div id="head_bg">
</div>
</div>
</header>
<!-- InstanceBeginEditable name="slide" -->
<div id="top_img">
<p>
<img src="images/contact/contact_topimg.png" width="900" height="120" alt="">
</p>
</div>
<!-- InstanceEndEditable -->
<nav>

<ul class="menu">
    <li class="menu__single" id="nav01">
        <a href="index.html#buslineup" class="init-bottom">貸切バス一覧</a>
        <ul class="menu__second-level">
            <li><a href="index.html#big_bus">大型バス</a></li>
            <li><a href="index.html#middle_bus">中型バス</a></li>
            <li><a href="index.html#small_bus">小型バス</a></li>
            <li><a href="index.html#micro_bus">マイクロバス</a></li>
        </ul>
    </li>
    <li class="menu__single" id="nav02">
        <a href="safety.html" class="init-bottom">安全への取組み</a>
        <ul class="menu__second-level">
            <li><a href="safety.html#safety_management">安全運転マネジメント</a></li>
            <li><a href="safety.html#safety_efforts">安全運転に対する取組み</a></li>
            <li><a href="safety.html#safety_certification">安全評価認定</a></li>
        </ul>
    </li>
    <li class="menu__single" id="nav03">
        <a href="info.html" class="init-bottom">会社案内</a>
        <ul class="menu__second-level">
            <li><a href="info.html#info_rinen">経営理念</a></li>
            <li><a href="info.html#info_overview">会社概要</a></li>
            <li><a href="info.html#info_access">アクセス</a></li>
            <li><a href="info.html#info_covid">感染拡大防止の取組み</a></li>
        </ul>
    </li>
    <li class="menu__single" id="nav04">
        <a href="contact.html" class="init-bottom">問い合わせ</a>
        <ul class="menu__second-level">
            <li><a href="contact.html#contact_form">コンタクト</a></li>
            <li><a href="contact.html#contact_policy">プライバシーポリシー</a></li>
        </ul>
    </li>
    <!-- 他グローバルナビメニュー省略 -->
</ul>
</nav>

<div id="main">
<!-- InstanceBeginEditable name="main" -->
<div class="contents_w">
<!-- ▲ Headerやその他コンテンツなど　※自由に編集可 ▲-->

<!-- ▼************ 送信内容表示部　※編集は自己責任で ************ ▼-->
<div id="formWrap">
<?php if($empty_flag == 1){ ?>
<h2>入力エラー</h2>
<div align="center">
<p class="contact_in">
入力にエラーがあります。下記をご確認の上「戻る」ボタンにて修正をお願い致します。
</p>
<?php echo $errm; ?><br /><br />
<p id="kakunin"><input class="sysNextSubmit" type="button" value=" 前画面に戻る " onClick="history.back()">
</p>
</div>

<?php }else{ ?>
<p class="contact_in">
以下の内容で間違いがなければ、「入力内容を送信する」ボタンを押してください。
</p>
<form action="<?php echo h($_SERVER['SCRIPT_NAME']); ?>" method="POST">
<table class="formTable">
<?php echo confirmOutput($_POST);//入力内容を表示?>
</table>
<p id="kakunin"><input type="hidden" name="mail_set" value="confirm_submit">
<input type="hidden" name="httpReferer" value="<?php echo h($_SERVER['HTTP_REFERER']);?>">
<input class="sysNextSubmit" type="submit" value="入力内容を送信する">
<input class="sysNextSubmit" type="button" value="前画面に戻る" onClick="history.back()"></p>
</form>
<?php } ?>
</div><!-- /formWrap -->
<!-- ▲ *********** 送信内容確認部　※編集は自己責任で ************ ▲-->

<!-- ▼ Footerその他コンテンツなど　※編集可 ▼-->
</div>
<!-- InstanceEndEditable -->
</div>

<footer>
<hr class="s_hide">
<div id="foot_link">
<ul>
<li>
<a href="https://daiichi-travel4112.co.jp/" target="_blank">
<img src="images/dst_link.png" width="150" height="58" alt="">
</a>
</li>
<li>
<a href="https://www.miyagi-bus-kyokai.jp/" target="_blank">
<img src="images/buskyokai_link.png" width="150" height="58" alt="">
</a>
</li>
</ul>
<div class="clear">
</div>
</div>

<div id="foot_nav">
<ul>
<li>
<a href="index.html">
TOP
</a>
</li>
<li>
<a href="index.html#buslineup">
貸切バス一覧
</a>
</li>
<li>
<a href="safety.html">
安全への取組み
</a>
</li>
<li>
<a href="info.html">
会社案内
</a>
</li>
<li id="noborder_r">
<a href="contact.html">
問い合わせ
</a>
</li>
</ul>
<div class="clear">
</div>
</div>

<div id="foot_title_area">
<div id="foot_title">
<a href="index.html">
第一観光バス
</a>
</div>
<p>
一般貸切旅客自動車運送事業・貸切観光バス
</p>
<div class="clear">
</div>
<div id="head_bg">
</div>
</div>

<p id="copy">
&copy;&nbsp;2020&nbsp;Daiichi&nbsp;Kanko&nbsp;Bus&nbsp;Co,LTD&nbsp;All&nbsp;Rights&quot;Reserved.
</p>

</footer>
<p id="pageTop"><a href="#"></a></p>

<input id="menu-cb" type="checkbox" value="off">
<label id="menu-icon" for="menu-cb"></label>
<label id="menu-background" for="menu-cb"></label>
<div id="ham-menu">
<ul>
<li>
<a href="index.html">
TOP
</a>
</li>
<li>
<a href="index.html#buslineup">
貸切バス一覧
</a>
</li>
<li>
<a href="safety.html">
安全への取組み
</a>
</li>
<li>
<a href="info.html">
会社案内
</a>
</li>
<li>
<a href="contact.html">
問い合わせ
</a>
</li>
</ul>
</div>
</body>
<!-- InstanceEnd --></html>
<?php
/* ▲▲▲送信確認画面のレイアウト　※オリジナルのデザインも適用可能▲▲▲　*/
}

if(($jumpPage == 0 && $sendmail == 1) || ($jumpPage == 0 && ($confirmDsp == 0 && $sendmail == 0))) { 

/* ▼▼▼送信完了画面のレイアウト　編集可 ※送信完了後に指定のページに移動しない場合のみ表示▼▼▼　*/
?>
<!DOCTYPE HTML>
<html><!-- InstanceBegin template="/Templates/Template.dwt" codeOutsideHTMLIsLocked="false" -->
<head>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-ZXLWNYYFFC"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-ZXLWNYYFFC');
</script>

<link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="favicon/favicon-16x16.png">
<link rel="manifest" href="favicon/site.webmanifest">
<link rel="mask-icon" href="favicon/safari-pinned-tab.svg" color="#5bbad5">
<meta name="msapplication-TileColor" content="#ffffff">
<meta name="theme-color" content="#ffffff">


<meta charset="utf-8">
<!-- InstanceBeginEditable name="doctitle" -->
<title>第一観光バス｜宮城県大崎市｜一般貸旅客自動車運送事業・貸切観光バス</title>
<!-- InstanceEndEditable -->
<meta name="description" content="宮城県大崎市で少人数からのマイクロバスから大型観光バスまで、幅広く貸し切りバスをご提供しています。宮城県バス協会所属">
<meta name="keywords" content="宮城県,大崎市,古川,マイクロバス,バス,大型観光バス,大型バス,貸し切りバス">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta name="viewport" content="width=device-width">

<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-cache"> 

<link href="css/style.css" rel="stylesheet" type="text/css" media="only screen and (min-width:751px)">
<link href="css/style_s.css" rel="stylesheet" type="text/css" media="only screen and (min-width:320px) and (max-width:750px)">
<!-- InstanceBeginEditable name="css" -->
<link href="css/contact.css" rel="stylesheet" type="text/css" media="only screen and (min-width:751px)">
<link href="css/contact_s.css" rel="stylesheet" type="text/css" media="only screen and (min-width:320px) and (max-width:750px)">
<link rel="stylesheet" type="text/css" href="css/slick.css" media="screen" />
<!-- InstanceEndEditable -->
<link href="css/slick-theme.css" rel="stylesheet" type="text/css" media="only screen and (min-width:751px)">
<link href="css/slick-theme_s.css" rel="stylesheet" type="text/css" media="only screen and (min-width:320px) and (max-width:750px)">
<script type="text/javascript" src="js/jquery-1.8.3.min.js"></script>
<!-- InstanceBeginEditable name="js" -->
<!-- InstanceEndEditable -->
</head>

<body>

<header>
<h1>
<a href="index.html">
第一観光バス
</a>
</h1>
<p>
一般貸切旅客自動車運送事業・貸切観光バス
</p>
<div class="clear">
</div>
<div id="head_bg">
</div>
</div>
</header>
<!-- InstanceBeginEditable name="slide" -->
<div id="top_img">
<p>
<img src="images/contact/contact_topimg.png" width="900" height="120" alt="">
</p>
</div>
<!-- InstanceEndEditable -->
<nav>

<ul class="menu">
    <li class="menu__single" id="nav01">
        <a href="index.html#buslineup" class="init-bottom">貸切バス一覧</a>
        <ul class="menu__second-level">
            <li><a href="index.html#big_bus">大型バス</a></li>
            <li><a href="index.html#middle_bus">中型バス</a></li>
            <li><a href="index.html#small_bus">小型バス</a></li>
            <li><a href="index.html#micro_bus">マイクロバス</a></li>
        </ul>
    </li>
    <li class="menu__single" id="nav02">
        <a href="safety.html" class="init-bottom">安全への取組み</a>
        <ul class="menu__second-level">
            <li><a href="safety.html#safety_management">安全運転マネジメント</a></li>
            <li><a href="safety.html#safety_efforts">安全運転に対する取組み</a></li>
            <li><a href="safety.html#safety_certification">安全評価認定</a></li>
        </ul>
    </li>
    <li class="menu__single" id="nav03">
        <a href="info.html" class="init-bottom">会社案内</a>
        <ul class="menu__second-level">
            <li><a href="info.html#info_rinen">経営理念</a></li>
            <li><a href="info.html#info_overview">会社概要</a></li>
            <li><a href="info.html#info_access">アクセス</a></li>
            <li><a href="info.html#info_covid">感染拡大防止の取組み</a></li>
        </ul>
    </li>
    <li class="menu__single" id="nav04">
        <a href="contact.html" class="init-bottom">問い合わせ</a>
        <ul class="menu__second-level">
            <li><a href="contact.html#contact_form">コンタクト</a></li>
            <li><a href="contact.html#contact_policy">プライバシーポリシー</a></li>
        </ul>
    </li>
    <!-- 他グローバルナビメニュー省略 -->
</ul>
</nav>

<div id="main">
<!-- InstanceBeginEditable name="main" -->
<div class="contents_w">
<!-- ▲ Headerやその他コンテンツなど　※自由に編集可 ▲-->

<!-- ▼************ 送信内容表示部　※編集は自己責任で ************ ▼-->
<div id="formWrap">
<?php if($empty_flag == 1){ ?>
<h2>入力エラー</h2>
<div align="center">
<p class="contact_in">
入力にエラーがあります。下記をご確認の上「戻る」ボタンにて修正をお願い致します。
</p>
<?php echo $errm; ?><br /><br />
<p id="kakunin"><input class="sysNextSubmit" type="button" value=" 前画面に戻る " onClick="history.back()">
</p>
</div>

<?php }else{ ?>
<p class="contact_in">
以下の内容で間違いがなければ、「入力内容を送信する」ボタンを押してください。
</p>
<form action="<?php echo h($_SERVER['SCRIPT_NAME']); ?>" method="POST">
<table class="formTable">
<?php echo confirmOutput($_POST);//入力内容を表示?>
</table>
<p id="kakunin"><input type="hidden" name="mail_set" value="confirm_submit">
<input type="hidden" name="httpReferer" value="<?php echo h($_SERVER['HTTP_REFERER']);?>">
<input class="sysNextSubmit" type="submit" value="入力内容を送信する">
<input class="sysNextSubmit" type="button" value="前画面に戻る" onClick="history.back()"></p>
</form>
<?php } ?>
</div><!-- /formWrap -->
<!-- ▲ *********** 送信内容確認部　※編集は自己責任で ************ ▲-->

<!-- ▼ Footerその他コンテンツなど　※編集可 ▼-->
</div>
<!-- InstanceEndEditable -->
</div>

<footer>
<hr class="s_hide">
<div id="foot_link">
<ul>
<li>
<a href="https://daiichi-travel4112.co.jp/" target="_blank">
<img src="images/dst_link.png" width="150" height="58" alt="">
</a>
</li>
<li>
<a href="https://www.miyagi-bus-kyokai.jp/" target="_blank">
<img src="images/buskyokai_link.png" width="150" height="58" alt="">
</a>
</li>
</ul>
<div class="clear">
</div>
</div>

<div id="foot_nav">
<ul>
<li>
<a href="index.html">
TOP
</a>
</li>
<li>
<a href="index.html#buslineup">
貸切バス一覧
</a>
</li>
<li>
<a href="safety.html">
安全への取組み
</a>
</li>
<li>
<a href="info.html">
会社案内
</a>
</li>
<li id="noborder_r">
<a href="contact.html">
問い合わせ
</a>
</li>
</ul>
<div class="clear">
</div>
</div>

<div id="foot_title_area">
<div id="foot_title">
<a href="index.html">
第一観光バス
</a>
</div>
<p>
一般貸切旅客自動車運送事業・貸切観光バス
</p>
<div class="clear">
</div>
<div id="head_bg">
</div>
</div>

<p id="copy">
&copy;&nbsp;2020&nbsp;Daiichi&nbsp;Kanko&nbsp;Bus&nbsp;Co,LTD&nbsp;All&nbsp;Rights&quot;Reserved.
</p>

</footer>
<p id="pageTop"><a href="#"></a></p>

<input id="menu-cb" type="checkbox" value="off">
<label id="menu-icon" for="menu-cb"></label>
<label id="menu-background" for="menu-cb"></label>
<div id="ham-menu">
<ul>
<li>
<a href="index.html">
TOP
</a>
</li>
<li>
<a href="index.html#buslineup">
貸切バス一覧
</a>
</li>
<li>
<a href="safety.html">
安全への取組み
</a>
</li>
<li>
<a href="info.html">
会社案内
</a>
</li>
<li>
<a href="contact.html">
問い合わせ
</a>
</li>
</ul>
</div>
</body>
<!-- InstanceEnd --></html>
<?php 
/* ▲▲▲送信完了画面のレイアウト 編集可 ※送信完了後に指定のページに移動しない場合のみ表示▲▲▲　*/
  }

//確認画面無しの場合の表示、指定のページに移動する設定の場合、エラーチェックで問題が無ければ指定ページヘリダイレクト
else if(($jumpPage == 1 && $sendmail == 1) || $confirmDsp == 0) { 
	if($empty_flag == 1){ ?>
<div align="center"><h4>入力にエラーがあります。下記をご確認の上「戻る」ボタンにて修正をお願い致します。</h4><div style="color:red"><?php echo $errm; ?></div><br /><br /><input type="button" value=" 前画面に戻る " onClick="history.back()"></div>
<?php 
	}else{ header("Location: ".$thanksPage); }
}

// 以下の変更は知識のある方のみ自己責任でお願いします。

//----------------------------------------------------------------------
//  関数定義(START)
//----------------------------------------------------------------------
function checkMail($str){
	$mailaddress_array = explode('@',$str);
	if(preg_match("/^[\.!#%&\-_0-9a-zA-Z\?\/\+]+\@[!#%&\-_0-9a-zA-Z]+(\.[!#%&\-_0-9a-zA-Z]+)+$/", "$str") && count($mailaddress_array) ==2){
		return true;
	}else{
		return false;
	}
}
function h($string) {
	global $encode;
	return htmlspecialchars($string, ENT_QUOTES,$encode);
}
function sanitize($arr){
	if(is_array($arr)){
		return array_map('sanitize',$arr);
	}
	return str_replace("\0","",$arr);
}
//Shift-JISの場合に誤変換文字の置換関数
function sjisReplace($arr,$encode){
	foreach($arr as $key => $val){
		$key = str_replace('＼','ー',$key);
		$resArray[$key] = $val;
	}
	return $resArray;
}
//送信メールにPOSTデータをセットする関数
function postToMail($arr){
	global $hankaku,$hankaku_array;
	$resArray = '';
	foreach($arr as $key => $val) {
		$out = '';
		if(is_array($val)){
			foreach($val as $key02 => $item){ 
				//連結項目の処理
				if(is_array($item)){
					$out .= connect2val($item);
				}else{
					$out .= $item . ', ';
				}
			}
			$out = rtrim($out,', ');
			
		}else{ $out = $val; }//チェックボックス（配列）追記ここまで
		
		if (version_compare(PHP_VERSION, '5.1.0', '<=')) {//PHP5.1.0以下の場合のみ実行（7.4でget_magic_quotes_gpcが非推奨になったため）
			if(get_magic_quotes_gpc()) { $out = stripslashes($out); }
		}
		
		//全角→半角変換
		if($hankaku == 1){
			$out = zenkaku2hankaku($key,$out,$hankaku_array);
		}
		if($out != "confirm_submit" && $key != "httpReferer") {
			$resArray .= "【 ".h($key)." 】 ".h($out)."\n";
		}
	}
	return $resArray;
}
//確認画面の入力内容出力用関数
function confirmOutput($arr){
	global $hankaku,$hankaku_array,$useToken,$confirmDsp,$replaceStr;
	$html = '';
	foreach($arr as $key => $val) {
		$out = '';
		if(is_array($val)){
			foreach($val as $key02 => $item){ 
				//連結項目の処理
				if(is_array($item)){
					$out .= connect2val($item);
				}else{
					$out .= $item . ', ';
				}
			}
			$out = rtrim($out,', ');
			
		}else{ $out = $val; }//チェックボックス（配列）追記ここまで
		
		if (version_compare(PHP_VERSION, '5.1.0', '<=')) {//PHP5.1.0以下の場合のみ実行（7.4でget_magic_quotes_gpcが非推奨になったため）
			if(get_magic_quotes_gpc()) { $out = stripslashes($out); }
		}
		
		//全角→半角変換
		if($hankaku == 1){
			$out = zenkaku2hankaku($key,$out,$hankaku_array);
		}
		
		$out = nl2br(h($out));//※追記 改行コードを<br>タグに変換
		$key = h($key);
		$out = str_replace($replaceStr['before'], $replaceStr['after'], $out);//機種依存文字の置換処理
		
		$html .= "<tr><th>".$key."</th><td>".$out;
		$html .= '<input type="hidden" name="'.$key.'" value="'.str_replace(array("<br />","<br>"),"",$out).'" />';
		$html .= "</td></tr>\n";
	}
	//トークンをセット
	if($useToken == 1 && $confirmDsp == 1){
		$token = sha1(uniqid(mt_rand(), true));
		$_SESSION['mailform_token'] = $token;
		$html .= '<input type="hidden" name="mailform_token" value="'.$token.'" />';
	}
	
	return $html;
}

//全角→半角変換
function zenkaku2hankaku($key,$out,$hankaku_array){
	global $encode;
	if(is_array($hankaku_array) && function_exists('mb_convert_kana')){
		foreach($hankaku_array as $hankaku_array_val){
			if($key == $hankaku_array_val){
				$out = mb_convert_kana($out,'a',$encode);
			}
		}
	}
	return $out;
}
//配列連結の処理
function connect2val($arr){
	$out = '';
	foreach($arr as $key => $val){
		if($key === 0 || $val == ''){//配列が未記入（0）、または内容が空のの場合には連結文字を付加しない（型まで調べる必要あり）
			$key = '';
		}elseif(strpos($key,"円") !== false && $val != '' && preg_match("/^[0-9]+$/",$val)){
			$val = number_format($val);//金額の場合には3桁ごとにカンマを追加
		}
		$out .= $val . $key;
	}
	return $out;
}

//管理者宛送信メールヘッダ
function adminHeader($post_mail,$BccMail){
	global $from;
	$header="From: $from\n";
	if($BccMail != '') {
	  $header.="Bcc: $BccMail\n";
	}
	if(!empty($post_mail)) {
		$header.="Reply-To: ".$post_mail."\n";
	}
	$header.="Content-Type:text/plain;charset=iso-2022-jp\nX-Mailer: PHP/".phpversion();
	return $header;
}
//管理者宛送信メールボディ
function mailToAdmin($arr,$subject,$mailFooterDsp,$mailSignature,$encode,$confirmDsp){
	$adminBody="「".$subject."」からメールが届きました\n\n";
	$adminBody .="＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝\n\n";
	$adminBody.= postToMail($arr);//POSTデータを関数からセット
	$adminBody.="\n＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝\n";
	$adminBody.="送信された日時：".date( "Y/m/d (D) H:i:s", time() )."\n";
	$adminBody.="送信者のIPアドレス：".@$_SERVER["REMOTE_ADDR"]."\n";
	$adminBody.="送信者のホスト名：".getHostByAddr(getenv('REMOTE_ADDR'))."\n";
	if($confirmDsp != 1){
		$adminBody.="問い合わせのページURL：".@$_SERVER['HTTP_REFERER']."\n";
	}else{
		$adminBody.="問い合わせのページURL：".@$arr['httpReferer']."\n";
	}
	if($mailFooterDsp == 1) $adminBody.= $mailSignature;
	return mb_convert_encoding($adminBody,"JIS",$encode);
}

//ユーザ宛送信メールヘッダ
function userHeader($refrom_name,$to,$encode){
	$reheader = "From: ";
	if(!empty($refrom_name)){
		$default_internal_encode = mb_internal_encoding();
		if($default_internal_encode != $encode){
			mb_internal_encoding($encode);
		}
		$reheader .= mb_encode_mimeheader($refrom_name)." <".$to.">\nReply-To: ".$to;
	}else{
		$reheader .= "$to\nReply-To: ".$to;
	}
	$reheader .= "\nContent-Type: text/plain;charset=iso-2022-jp\nX-Mailer: PHP/".phpversion();
	return $reheader;
}
//ユーザ宛送信メールボディ
function mailToUser($arr,$dsp_name,$remail_text,$mailFooterDsp,$mailSignature,$encode){
	$userBody = '';
	if(isset($arr[$dsp_name])) $userBody = h($arr[$dsp_name]). " 様\n";
	$userBody.= $remail_text;
	$userBody.="\n＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝\n\n";
	$userBody.= postToMail($arr);//POSTデータを関数からセット
	$userBody.="\n＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝\n\n";
	$userBody.="送信日時：".date( "Y/m/d (D) H:i:s", time() )."\n";
	if($mailFooterDsp == 1) $userBody.= $mailSignature;
	return mb_convert_encoding($userBody,"JIS",$encode);
}
//必須チェック関数
function requireCheck($require){
	$res['errm'] = '';
	$res['empty_flag'] = 0;
	foreach($require as $requireVal){
		$existsFalg = '';
		foreach($_POST as $key => $val) {
			if($key == $requireVal) {
				
				//連結指定の項目（配列）のための必須チェック
				if(is_array($val)){
					$connectEmpty = 0;
					foreach($val as $kk => $vv){
						if(is_array($vv)){
							foreach($vv as $kk02 => $vv02){
								if($vv02 == ''){
									$connectEmpty++;
								}
							}
						}
						
					}
					if($connectEmpty > 0){
						$res['errm'] .= "<p class=\"error_messe\">【".h($key)."】は必須項目です。</p>\n";
						$res['empty_flag'] = 1;
					}
				}
				//デフォルト必須チェック
				elseif($val == ''){
					$res['errm'] .= "<p class=\"error_messe\">【".h($key)."】は必須項目です。</p>\n";
					$res['empty_flag'] = 1;
				}
				
				$existsFalg = 1;
				break;
			}
			
		}
		if($existsFalg != 1){
				$res['errm'] .= "<p class=\"error_messe\">【".$requireVal."】が未選択です。</p>\n";
				$res['empty_flag'] = 1;
		}
	}
	
	return $res;
}
//リファラチェック
function refererCheck($Referer_check,$Referer_check_domain){
	if($Referer_check == 1 && !empty($Referer_check_domain)){
		if(strpos($_SERVER['HTTP_REFERER'],$Referer_check_domain) === false){
			return exit('<p align="center">リファラチェックエラー。フォームページのドメインとこのファイルのドメインが一致しません</p>');
		}
	}
}
function copyright(){
	echo '<a style="display:block;text-align:center;margin:15px 0;font-size:11px;color:#aaa;text-decoration:none" href="http://www.php-factory.net/" target="_blank">- PHP工房 -</a>';
}
//----------------------------------------------------------------------
//  関数定義(END)
//----------------------------------------------------------------------
?>